//
// glDemo.h - definitions header file for glDemo.c
//
#define OSR2_BUILD_NUMBER 1111

typedef struct
   {
    int   width;
    int   height;
    int   bpp;
    int   flags;
    int   frequency;
   }screen_res_t;

typedef struct
   {
    HINSTANCE        hInstance;
    int              iCmdShow;
    HWND             hWnd;
    HDC              hDC;
    HGLRC            hGLRC;
    BOOL             bActive;
    BOOL             bFullScreen;
    ATOM             wndclass;
    WNDPROC          wndproc;
    int              width;
    int              height;
    int              bpp;
    BOOL             bChangeBPP;
    BOOL             bAllowSoft;
    char            *szCmdLine;
    int              argc;
    char           **argv;
    int              glnWidth;
    int              glnHeight;
    float            gldAspect;
    float            NearClip;
    float            FarClip;
    float            fov;
    int              iResCount;
    screen_res_t    *pResolutions;
    int              iVidMode;
   }windata_t;

typedef struct
   {
    int  width;
    int  height;
    int  bpp;
   }devinfo_t;

void GetParameters( void );
int  FindNumParameter(char *s);
BOOL FindParameter(char *s);
void BuildModeList(void);
BOOL SetVideoMode(void);
BOOL InitOpenGL(void);
void LoadTexture(void);
void RenderScene(void);

void ShutdownOpenGL(void);
void Cleanup(void);

